

<?php $__env->startSection('content'); ?>
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Edit Role: <?php echo e($role->name); ?></h1>
        <p>Modify role details and assigned permissions</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Role Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="<?php echo e(route('admin.roles.update', $role)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group">
                    <label for="name">Role Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name', $role->name)); ?>" <?php echo e(in_array($role->name, ['super-admin', 'admin']) ? 'readonly' : ''); ?> required>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <div class="form-text">Enter a unique name for this role (e.g., "editor", "manager")</div>
                </div>

                <div class="form-group">
                    <label for="color">Display Color</label>
                    <div class="color-picker-wrapper">
                        <input type="color" id="color" name="color" class="color-picker-input" value="<?php echo e(old('color', $role->color ?? '#4B8BFF')); ?>" required>
                        <input type="text" id="color-text" class="form-control color-text-input" value="<?php echo e(old('color', $role->color ?? '#4B8BFF')); ?>" pattern="^#([A-Fa-f0-9]{6})$" required>
                    </div>
                    <?php $__errorArgs = ['color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <div class="form-text">Choose a color to display this role with</div>
                </div>

                <div class="form-group">
                    <label for="order">Display Order</label>
                    <input type="number" class="form-control" id="order" name="order" value="<?php echo e(old('order', $role->order ?? 0)); ?>" min="0">
                    <?php $__errorArgs = ['order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <div class="form-text">Lower numbers appear first (e.g., 0, 1, 2, 3...)</div>
                </div>

                <div class="form-group">
                    <label>Permissions</label>
                    <div class="permission-groups">
                        <div class="permission-group">
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input type="checkbox" id="permission_<?php echo e($permission->name); ?>" name="permissions[]" value="<?php echo e($permission->id); ?>" <?php echo e(in_array($permission->id, old('permissions', $rolePermissions)) ? 'checked' : ''); ?>>
                                    <label for="permission_<?php echo e($permission->id); ?>"><?php echo e($permission->name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Update Role</button>
                    <a href="<?php echo e(route('admin.roles')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const colorPicker = document.getElementById('color');
    const colorText = document.getElementById('color-text');
    
    colorPicker.addEventListener('input', function() {
        colorText.value = this.value.toUpperCase();
    });
    
    colorText.addEventListener('input', function() {
        if (/^#[A-Fa-f0-9]{6}$/.test(this.value)) {
            colorPicker.value = this.value;
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/roles/edit.blade.php ENDPATH**/ ?>